const textSizeSlider = document.getElementById("nr-ext-textsize");
const textSizeValueSender = document.getElementById("nr-ext-textsize-value-sender");
$(textSizeSlider).ionRangeSlider({
    skin: "round",
    type: "single",
    min: 0.75,
    max: 2.00,
    from: 1.00,
    step: 0.25,
    hide_min_max: true,
    onChange: function(data) {
        const text_scale = data['from'] + '';
        const real_scale = $('#nr-immersive-reader-text').attr('text-scale');
        if (text_scale != real_scale) {
            setTextScale(text_scale);
        }
    },
    onFinish: function(data) {
        $(textSizeValueSender).val(JSON.stringify(data['from']));
        const event = new Event('change');
        textSizeValueSender.dispatchEvent(event);
    },
});
$(textSizeValueSender).on('change', function(e) {
    let value = 1;
    if (!isNaN(e.target.value)) {
        value = e.target.value;
    }
    $(textSizeSlider).data("ionRangeSlider").update({
        from: value
    });
});
function setTextScale(scaleNum) {
    $('#nr-immersive-reader-text').attr('text-scale', scaleNum);
}